/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.tiles;

import codechicken.lib.raytracer.IndexedCuboid6;
import cofh.CoFHCore;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.DuctTransport;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.entity.DuctUnitTransport;
import cofh.thermaldynamics.duct.entity.DuctUnitTransportBase;
import cofh.thermaldynamics.duct.entity.DuctUnitTransportLinking;
import cofh.thermaldynamics.duct.entity.DuctUnitTransportLongRange;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;

public class TileTransportDuct
extends TileGrid {
    DuctUnitTransportBase transport;

    public TileTransportDuct() {
        this(TDDucts.transportBasic);
    }

    public TileTransportDuct(DuctTransport transportBasic) {
        this.transport = this.createDuctUnit(transportBasic);
    }

    @Nonnull
    public DuctUnitTransportBase createDuctUnit(DuctTransport transportBasic) {
        return new DuctUnitTransport(this, transportBasic);
    }

    @Override
    @Nullable
    public <T extends DuctUnit<T, G, C>, G extends MultiBlockGrid<T>, C> T getDuct(DuctToken<T, G, C> token) {
        if (token == DuctToken.TRANSPORT) {
            return (T)this.transport;
        }
        return null;
    }

    @Override
    public Iterable<DuctUnit> getDuctUnits() {
        return ImmutableList.of((Object)this.transport);
    }

    @Override
    public Duct getDuctType() {
        return this.transport.getDuctType();
    }

    @Override
    public void addTraceableCuboids(List<IndexedCuboid6> cuboids) {
        EntityPlayer player = CoFHCore.proxy.getClientPlayer();
        if (player != null && player.func_184187_bx() != null && player.func_184187_bx().getClass() == EntityTransport.class) {
            return;
        }
        super.addTraceableCuboids(cuboids);
    }

    public static class LongRange
    extends TileTransportDuct {
        public LongRange() {
            super(TDDucts.transportLongRange);
        }

        @Override
        @Nonnull
        public DuctUnitTransportBase createDuctUnit(DuctTransport duct) {
            return new DuctUnitTransportLongRange(this, duct);
        }
    }

    public static class Linking
    extends TileTransportDuct {
        public Linking() {
            super(TDDucts.transportLinking);
        }

        @Override
        @Nonnull
        public DuctUnitTransportBase createDuctUnit(DuctTransport duct) {
            return new DuctUnitTransportLinking(this, duct);
        }
    }
}

